## Flow

You can create a simple app with the following code:

```Python 
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, flowui
import copy 
class App:
    
    class Config(plus.AppInMemory.Config):
        is_horizontal = False
        height = "800px"

    @mark_create_layout
    def my_layout(self):
        nodes = [
            flowui.Node(id="1", type="input", data=flowui.NodeData(label="Right Click On Me!"), position=flowui.XYPosition(0, 0)),
            flowui.Node(id="2", type="default", data=flowui.NodeData(label="Right Click On Me!"), position=flowui.XYPosition(0, 100)),
            flowui.Node(id="3", type="output", data=flowui.NodeData(label="Right Click On Me!"), position=flowui.XYPosition(0, 200)),

        ]
        items = [
            mui.MenuItem(id="delete", label="Delete Node"),
            mui.MenuItem(id="duplicate", label="Duplicate Node"),
            mui.MenuItem(id="divid", divider=True),
            mui.MenuItem(id="hello", label="hello"),

        ]
        graph = flowui.Flow(nodes, [], [
            flowui.MiniMap(),
            flowui.Controls(),
            flowui.Background()
        ]).prop(nodeContextMenuItems=items)
        graph.event_node_context_menu.on(self.change_node)
        self.graph = graph
        return mui.HBox([
            graph,
        ]).prop(width="100%", height="100%", overflow="hidden")

    async def change_node(self, data):
        item_id = data["itemId"]
        mouse_x = data["clientOffset"]["x"]
        mouse_y = data["clientOffset"]["y"]
        node_id = data["nodeId"]
        node = self.graph.get_node_by_id(node_id)
        if item_id == "delete":
            await self.graph.delete_nodes_by_ids([node_id])
        elif item_id == "duplicate":
            new_node = copy.deepcopy(node) # for custom node, you must handle component copy by yourself
            new_node.id = self.graph.create_unique_node_id(node.id)
            new_node.position.x += 15
            new_node.position.y += 15
            # here we use position from existing node, so we don't need to convert screen position to flowui position
            await self.graph.add_node(new_node, screen_to_flow=False)

```

